import multiprocessing

# Server socket
bind = "0.0.0.0:5009"
backlog = 2048

# Worker processes
workers = multiprocessing.cpu_count() * 2 + 1
worker_class = 'sync'
worker_connections = 1000
timeout = 120
keepalive = 2

# Logging
accesslog = 'logs/gunicorn_access.log'
errorlog = 'logs/gunicorn_error.log'
loglevel = 'info'

# Process naming
proc_name = 'imcode-api'

# Server mechanics
daemon = False
pidfile = 'gunicorn.pid'
