from flask import jsonify
from werkzeug.exceptions import HTTPException


def register_error_handlers(app):
    """Register error handlers for the application"""

    @app.errorhandler(400)
    def bad_request(e):
        return jsonify({'message': 'Bad request'}), 400

    @app.errorhandler(401)
    def unauthorized(e):
        return jsonify({'message': 'Unauthorized'}), 401

    @app.errorhandler(403)
    def forbidden(e):
        return jsonify({'message': 'Forbidden'}), 403

    @app.errorhandler(404)
    def not_found(e):
        return jsonify({'message': 'Resource not found'}), 404

    @app.errorhandler(500)
    def internal_server_error(e):
        return jsonify({'message': 'Internal server error'}), 500

    @app.errorhandler(HTTPException)
    def handle_http_exception(e):
        return jsonify({'message': str(e)}), e.code

    @app.errorhandler(Exception)
    def handle_exception(e):
        return jsonify({'message': 'An unexpected error occurred'}), 500
